//NodeMCU/ESP8266 implement WebSocketsServer to control RGB LED
//arduino-er.blogspot.com

#include <Arduino.h>

#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <WebSocketsServer.h>
#include <ESP8266WebServer.h>
#include <ESP8266mDNS.h>
#include <Hash.h>
#include <Servo.h> 

Servo myservo;

#include "FS.h"



ESP8266WiFiMulti WiFiMulti;

ESP8266WebServer server = ESP8266WebServer(80);
WebSocketsServer webSocket = WebSocketsServer(81);

String html_home;
String bejovo;
String honnan;
String hova;
String sebesseg;
int pos;
int szervopin=D8;
int statusled=D1;

void webSocketEvent(uint8_t num, WStype_t type, uint8_t * payload, size_t lenght) {

    switch(type) {
        case WStype_DISCONNECTED:
            Serial.printf("[%u] Disconnected!\n", num);
            break;
        case WStype_CONNECTED: {
            IPAddress ip = webSocket.remoteIP(num);
            Serial.printf("[%u] Connected from %d.%d.%d.%d url: %s\n", num, ip[0], ip[1], ip[2], ip[3], payload);

            // send message to client
            webSocket.sendTXT(num, "Connected");
        }
            break;
            
        case WStype_TEXT: {
            Serial.printf("[%u] get Text: %s\n", num, payload);
            bejovo = String((char*)payload);           
            Serial.print("bejovo: ");Serial.println(bejovo);

            if(payload[0] == 'A') {
                Serial.println("Vezerloparancs OK");
                digitalWrite(statusled, LOW); delay(100); digitalWrite(statusled, HIGH);
                honnan=bejovo.substring(1,bejovo.indexOf('_'));
                hova=bejovo.substring(bejovo.indexOf('_')+1,bejovo.indexOf(','));
                sebesseg=bejovo.substring(bejovo.indexOf(',')+1);
                Serial.println("honnan: "+honnan);
                Serial.println("hova: "+hova);
                Serial.println("sebesseg: "+sebesseg);

                //azonnali ugrás:
                if (sebesseg=="0") {
                myservo.write( hova.toInt() );
                }

                if (sebesseg.toInt()>0 and honnan.toInt()<hova.toInt()) {
                  myservo.write( honnan.toInt() );
                  for (int i=honnan.toInt(); i<hova.toInt(); i++)
                  {
                    myservo.write( i );
                    delay(sebesseg.toInt());
                  }
                }
                 
                if (sebesseg.toInt()>0 and honnan.toInt()>hova.toInt()) {
                  myservo.write( honnan.toInt() );
                  for (int i=honnan.toInt(); i>hova.toInt(); i--)
                  {
                    myservo.write( i );
                    delay(sebesseg.toInt());
                  }
                  
                }
                        
       } //end of 'A' bemenet
    }
    break;

  } //end switch
}

void prepareFile(){
  
  Serial.println("Prepare file system");
  SPIFFS.begin();
  
  File file = SPIFFS.open("/home.html", "r");
  if (!file) {
    Serial.println("file open failed");  
  } else{
    Serial.println("file open success");

    html_home = "";
    while (file.available()) {
      //Serial.write(file.read());
      String line = file.readStringUntil('\n');
      html_home += line + "\n";
    }
    file.close();

    Serial.print(html_home);
  }
}

void setup() {
    //Serial.begin(921600);    
    Serial.begin(115200);

    //Serial.setDebugOutput(true);

    Serial.println();
    Serial.println();
    Serial.println();

    for(uint8_t t = 4; t > 0; t--) {
        Serial.printf("[SETUP] BOOT WAIT %d...\n", t);
        Serial.flush();
        delay(1000);
    }


    pinMode(statusled, OUTPUT);
    
    digitalWrite(statusled, HIGH);
        
    prepareFile();

    WiFi.softAP("Servocontrol", "12345678");
    IPAddress myIP = WiFi.softAPIP();
    Serial.print("AP IP address: ");
    Serial.println(myIP);

    // start webSocket server
    webSocket.begin();
    webSocket.onEvent(webSocketEvent);

    if(MDNS.begin("esp8266")) {
        Serial.println("MDNS responder started");
        digitalWrite(statusled, HIGH);
    }
    else {
          Serial.println("ERROR: MDNS responder NOT started");
          for (int i=0; i<100; i++) {
            digitalWrite(statusled, LOW);
            delay(200);
            digitalWrite(statusled, HIGH);
          }
    }
    

    // handle index
    server.on("/", []() {
        // send home.html
        server.send(200, "text/html", html_home);
    });

    server.begin();

    // Add service to MDNS
    MDNS.addService("http", "tcp", 80);
    MDNS.addService("ws", "tcp", 81);


    Serial.printf("Server Start\n");
    myservo.attach(szervopin);

}

void loop() {
    webSocket.loop();
    server.handleClient();
}

